(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      9759,        402]*)
(*NotebookOutlinePosition[     10603,        429]*)
(*  CellTagsIndexPosition[     10559,        425]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    \( (*\ 
      Example\ 6.5  .1 . \[IndentingNewLine]The\ gausspoints\ are\ denoted\ \
by\ s, \ and\ the\ weights\ by\ a\ \ *) \n\(s1 = 0.0623765;\)\), "\n", 
    \(\(s2 = 0.319396;\)\), "\n", 
    \(\(s3 = 0.745292;\)\), "\n", 
    \(\(s4 = 1.28266;\)\)}], "Input"],

Cell[BoxData[
    \(a1 = 0.0506142681; \na2 = 0.1111905172; \na3 = 0.1568533229; \n
    a4 = 0.1813418917; \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(b11 = 
      \((2/3)\)*a1*
        \((\ 1/\((5/3 - Cos[s1 + s1])\) + 1/\((5/3 + Cos[s1 - s1])\) + 
            1/\((5/3 + Cos[s1 + s1])\) + 1/\((5/3 - Cos[s1 - s1])\)\ )\)\)], 
  "Input"],

Cell[BoxData[
    \(0.125989425351739203`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b12 = 
      \((2/3)\)*a2*
        \((\ 1/\((5/3 - Cos[s2 + s1])\) + 1/\((5/3 + Cos[s2 - s1])\) + 
            1/\((5/3 + Cos[s2 + s1])\) + 1/\((5/3 - Cos[s2 - s1])\)\ )\)\)], 
  "Input"],

Cell[BoxData[
    \(0.263035659971760971`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b13 = 
      \((2/3)\)*a3*
        \((\ 1/\((5/3 - Cos[s3 + s1])\) + 1/\((5/3 + Cos[s3 - s1])\) + 
            1/\((5/3 + Cos[s3 + s1])\) + 1/\((5/3 - Cos[s3 - s1])\)\ )\)\)], 
  "Input"],

Cell[BoxData[
    \(0.311730771294812081`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b14 = 
      \((2/3)\)*a4*
        \((\ 1/\((5/3 - Cos[s4 + s1])\) + 1/\((5/3 + Cos[s4 - s1])\) + 
            1/\((5/3 + Cos[s4 + s1])\) + 1/\((5/3 - Cos[s4 - s1])\)\ )\)\)], 
  "Input"],

Cell[BoxData[
    \(0.299243009320160613`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b21 = 
      \((2/3)\)*a1*
        \((\ 1/\((5/3 - Cos[s1 + s2])\) + 1/\((5/3 + Cos[s1 - s2])\) + 
            1/\((5/3 + Cos[s1 + s2])\) + 1/\((5/3 - Cos[s1 - s2])\)\ )\)\)], 
  "Input"],

Cell[BoxData[
    \(0.119734647782276404`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b22 = 
      \((2/3)\)*a2*
        \((\ 1/\((5/3 - Cos[s2 + s2])\) + 1/\((5/3 + Cos[s2 - s2])\) + 
            1/\((5/3 + Cos[s2 + s2])\) + 1/\((5/3 - Cos[s2 - s2])\)\ )\)\)], 
  "Input"],

Cell[BoxData[
    \(0.254815403802251161`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b23 = 
      \((2/3)\)*a3*
        \((\ 1/\((5/3 - Cos[s3 + s2])\) + 1/\((5/3 + Cos[s3 - s2])\) + 
            1/\((5/3 + Cos[s3 + s2])\) + 1/\((5/3 - Cos[s3 - s2])\)\ )\)\)], 
  "Input"],

Cell[BoxData[
    \(0.315971584151660378`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b24 = 
      \((2/3)\)*a4*
        \((\ 1/\((5/3 - Cos[s4 + s2])\) + 1/\((5/3 + Cos[s4 - s2])\) + 
            1/\((5/3 + Cos[s4 + s2])\) + 1/\((5/3 - Cos[s4 - s2])\)\ )\)\)], 
  "Input"],

Cell[BoxData[
    \(0.309478462730769265`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b31 = 
      \((2/3)\)*a1*
        \((\ 1/\((5/3 - Cos[s1 + s3])\) + 1/\((5/3 + Cos[s1 - s3])\) + 
            1/\((5/3 + Cos[s1 + s3])\) + 1/\((5/3 - Cos[s1 - s3])\)\ )\)\)], 
  "Input"],

Cell[BoxData[
    \(0.100590950460096384`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b32 = 
      \((2/3)\)*a2*
        \((\ 1/\((5/3 - Cos[s2 + s3])\) + 1/\((5/3 + Cos[s2 - s3])\) + 
            1/\((5/3 + Cos[s2 + s3])\) + 1/\((5/3 - Cos[s2 - s3])\)\ )\)\)], 
  "Input"],

Cell[BoxData[
    \(0.223986608716763324`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b33 = 
      \((2/3)\)*a3*
        \((\ 1/\((5/3 - Cos[s3 + s3])\) + 1/\((5/3 + Cos[s3 - s3])\) + 
            1/\((5/3 + Cos[s3 + s3])\) + 1/\((5/3 - Cos[s3 - s3])\)\ )\)\)], 
  "Input"],

Cell[BoxData[
    \(0.321840009755215694`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b34 = 
      \((2/3)\)*a4*
        \((\ 1/\((5/3 - Cos[s4 + s3])\) + 1/\((5/3 + Cos[s4 - s3])\) + 
            1/\((5/3 + Cos[s4 + s3])\) + 1/\((5/3 - Cos[s4 - s3])\)\ )\)\)], 
  "Input"],

Cell[BoxData[
    \(0.353576409722745754`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b41 = 
      \((2/3)\)*a1*
        \((\ 1/\((5/3 - Cos[s1 + s4])\) + 1/\((5/3 + Cos[s1 - s4])\) + 
            1/\((5/3 + Cos[s1 + s4])\) + 1/\((5/3 - Cos[s1 - s4])\)\ )\)\)], 
  "Input"],

Cell[BoxData[
    \(0.0835216052881916937`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b42 = 
      \((2/3)\)*a2*
        \((\ 1/\((5/3 - Cos[s2 + s4])\) + 1/\((5/3 + Cos[s2 - s4])\) + 
            1/\((5/3 + Cos[s2 + s4])\) + 1/\((5/3 - Cos[s2 - s4])\)\ )\)\)], 
  "Input"],

Cell[BoxData[
    \(0.189757976001610018`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b43 = 
      \((2/3)\)*a3*
        \((\ 1/\((5/3 - Cos[s3 + s4])\) + 1/\((5/3 + Cos[s3 - s4])\) + 
            1/\((5/3 + Cos[s3 + s4])\) + 1/\((5/3 - Cos[s3 - s4])\)\ )\)\)], 
  "Input"],

Cell[BoxData[
    \(0.305829139886845791`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b44 = 
      \((2/3)\)*a4*
        \((\ 1/\((5/3 - Cos[s4 + s4])\) + 1/\((5/3 + Cos[s4 - s4])\) + 
            1/\((5/3 + Cos[s4 + s4])\) + 1/\((5/3 - Cos[s4 - s4])\)\ )\)\)], 
  "Input"],

Cell[BoxData[
    \(0.420913972578328454`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(m = {{1.125989425351739203`, 0.263035659971760971`, \ 
          0.311730771294812081`, \ 0.299243009320160613`}, \n
        \t\t{0.119734647782276404`, \ 1.254815403802251161`, \n\t\t\t
          0.315971584151660378`, \ 0.309478462730769265`}, \n
        \t\t{0.100590950460096384`, \ 0.223986608716763324`, \n\t\t\t
          1.321840009755215694`, \ 0.353576409722745754`}, \n
        \t\t{0.0835216052881916937`, \ 0.189757976001610018`, \n\t\t\t
          0.305829139886845791`, \ 1.420913972578328454`}\ }; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[t_] := \ \((5 + 3*Cos[2\ t])\)/\((16*\[Pi])\); \nf[s1]\)], "Input"],

Cell[BoxData[
    \(0.158691111770774799`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[s2]\)], "Input"],

Cell[BoxData[
    \(0.147386424868701526`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[s3]\)], "Input"],

Cell[BoxData[
    \(0.104254028081205274`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[s4]\)], "Input"],

Cell[BoxData[
    \(0.049427586275931441`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(g = {0.158691111770774799`, \ 0.147386424868701526`, \n\t\t
        0.104254028081205274`, \ 0.049427586275931441`}; \n
    LinearSolve[m, g]\)], "Input"],

Cell[BoxData[
    \({0.103033605070188949`, 0.0928594522241614228`, 0.0540379735076267042`, 
      0.00469757187621084604`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ 
      Exact\ \(solution : \ mu \((t)\)\) = 
        \((25 + 27\ cos\ 2  t)\)/\((160\ \[Pi])\)\ *) mu[t_] := \ 
      \((25 + 27\ Cos[2\ t])\)/\((160\ \[Pi])\); \nmu[0] // N\)\)], "Input"],

Cell[BoxData[
    \(0.103450713009731987`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mu[\[Pi]/8] // N\)], "Input"],

Cell[BoxData[
    \(0.0877180143040952131`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mu[\[Pi]/4] // N\)], "Input"],

Cell[BoxData[
    \(0.0497359197162172961`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mu[\[Pi]/2] // N\)], "Input"],

Cell[BoxData[
    \(\(-0.00397887357729738369`\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mu[s1] // N\)], "Input"],

Cell[BoxData[
    \(0.10303326482072348`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mu[s2] // N\)], "Input"],

Cell[BoxData[
    \(0.0928590466088575539`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mu[s3] // N\)], "Input"],

Cell[BoxData[
    \(0.0540398895001109202`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mu[s4] // N\)], "Input"],

Cell[BoxData[
    \(0.00469609187536446004`\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{Automatic, 91}, {Automatic, 14}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 284, 6, 123, "Input"],
Cell[2004, 57, 120, 2, 75, "Input"],

Cell[CellGroupData[{
Cell[2149, 63, 207, 5, 75, "Input"],
Cell[2359, 70, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2451, 76, 207, 5, 75, "Input"],
Cell[2661, 83, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2753, 89, 207, 5, 75, "Input"],
Cell[2963, 96, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3055, 102, 207, 5, 75, "Input"],
Cell[3265, 109, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3357, 115, 207, 5, 59, "Input"],
Cell[3567, 122, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3659, 128, 207, 5, 59, "Input"],
Cell[3869, 135, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3961, 141, 207, 5, 59, "Input"],
Cell[4171, 148, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4263, 154, 207, 5, 59, "Input"],
Cell[4473, 161, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4565, 167, 207, 5, 59, "Input"],
Cell[4775, 174, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4867, 180, 207, 5, 59, "Input"],
Cell[5077, 187, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5169, 193, 207, 5, 59, "Input"],
Cell[5379, 200, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5471, 206, 207, 5, 59, "Input"],
Cell[5681, 213, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5773, 219, 207, 5, 59, "Input"],
Cell[5983, 226, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6076, 232, 207, 5, 59, "Input"],
Cell[6286, 239, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6378, 245, 207, 5, 59, "Input"],
Cell[6588, 252, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6680, 258, 207, 5, 59, "Input"],
Cell[6890, 265, 55, 1, 26, "Output"]
}, Open  ]],
Cell[6960, 269, 551, 8, 139, "Input"],

Cell[CellGroupData[{
Cell[7536, 281, 89, 1, 43, "Input"],
Cell[7628, 284, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7720, 290, 38, 1, 27, "Input"],
Cell[7761, 293, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7853, 299, 38, 1, 27, "Input"],
Cell[7894, 302, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7986, 308, 38, 1, 27, "Input"],
Cell[8027, 311, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8119, 317, 174, 3, 59, "Input"],
Cell[8296, 322, 137, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8470, 329, 215, 4, 59, "Input"],
Cell[8688, 335, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8780, 341, 49, 1, 27, "Input"],
Cell[8832, 344, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8925, 350, 49, 1, 27, "Input"],
Cell[8977, 353, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9070, 359, 49, 1, 27, "Input"],
Cell[9122, 362, 62, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9221, 368, 44, 1, 27, "Input"],
Cell[9268, 371, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9359, 377, 44, 1, 27, "Input"],
Cell[9406, 380, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9499, 386, 44, 1, 27, "Input"],
Cell[9546, 389, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9639, 395, 44, 1, 27, "Input"],
Cell[9686, 398, 57, 1, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

